
alter table sys_role_group
    add column type varchar(255) comment '角色类型';
alter table sys_role_group
    add column type_id varchar(255) comment '类型标识';
create index idx_role_group_type on sys_role_group (type);
create index idx_role_group_typeid on sys_role_group (type_id);

alter table sys_business_operation
    add column field_permission_auto_filter bit default 0 comment
        '是否自动过滤字段权限';
alter table sys_business_param
    add column data_permission_enabled bit default 1 comment '是否应于数据权限过滤';
alter table sys_business_param
    add column field_permission_enabled bit default 1 comment '是否应于字段权限过滤';
alter table sys_business_param
    add column base_field bit default 1 comment '是否为基础字段';

CREATE TABLE `sys_role_field_permission`
(
    `id`                   bigint       NOT NULL COMMENT '记录唯一ID',
    `role_code`            varchar(255) NOT NULL COMMENT '角色编码',
    `permission_type`      varchar(255) NOT NULL COMMENT '权限类型',
    `app_code`             varchar(255) DEFAULT NULL COMMENT '应用编码',
    `menu_code`            varchar(255) DEFAULT NULL COMMENT '菜单编码',
    `business_object_code` varchar(255) DEFAULT NULL COMMENT '业务对象编码',
    `operation_code`       varchar(255) DEFAULT NULL COMMENT '操作编码',
    `field_name`           varchar(255) DEFAULT NULL COMMENT '字段名称',
    `readable`             bit(1)       DEFAULT b'1' COMMENT '可读',
    `writeable`            bit(1)       DEFAULT b'1' COMMENT '可写',
    `tenant_id`            bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`        bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`        bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`   int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`          bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`            bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`),
    KEY `idx_role_fieldperm_role` (`role_code`),
    KEY `idx_role_fieldperm_type` (`permission_type`),
    KEY `idx_role_fieldperm_menu` (`menu_code`),
    KEY `idx_role_fieldperm_obj` (`business_object_code`),
    KEY `idx_role_fieldperm_opera` (`operation_code`)
) COMMENT ='角色与字段权限的关联';